#include <algorithm>
#include <iostream>
#include <vector>

bool is_polyndrome(int a) {
    if (a < 1) return false;
    std::string s = std::to_string(a);
    bool ans = true;
    for (int i = 0; i < s.size(); ++i) {
        if (s[i] != s[s.size() - 1 - i]) {
            ans = false;
            break;
        }
    }
    return ans;
}

int main() {
    std::vector<int> polyndromes(0);
    for (int i = 1; i < 1000; ++i) {
        if (is_polyndrome(i)) {
            polyndromes.push_back(i);
        }
    }

    std::vector<int> answers(1000, 1e9);
    for (int i = 1; i < answers.size(); ++i) {
        if (is_polyndrome(i)) {
            answers[i] = 1;
        } else {
            for (auto x : polyndromes) {
                if (x < i) {
                    answers[i] = std::min(answers[i], 1 + answers[i - x]);
                } else {
                    break;
                }
            }
        }
    }

    int t;
    std::cin >> t;
    for (int step = 0; step < t; ++step) {
        int n;
        std::cin >> n;
        std::cout << answers[n] << "\n";
    }
}